/*
 * Decompiled with CFR 0.152.
 */
package com.samvolvo.discordlinked;

import com.samvolvo.discordlinked.api.Metrics;
import com.samvolvo.discordlinked.api.UpdateChecker;
import com.samvolvo.discordlinked.api.database.CodeCache;
import com.samvolvo.discordlinked.api.database.Database;
import com.samvolvo.discordlinked.api.database.PlayerCache;
import com.samvolvo.discordlinked.api.database.utils.PlayerDataUtil;
import com.samvolvo.discordlinked.api.tools.DiscordTools;
import com.samvolvo.discordlinked.api.tools.Messages;
import com.samvolvo.discordlinked.api.tools.MinecraftTools;
import com.samvolvo.discordlinked.discord.commands.Account;
import com.samvolvo.discordlinked.discord.events.DcChatEvent;
import com.samvolvo.discordlinked.discord.managers.CommandManager;
import com.samvolvo.discordlinked.discord.managers.EmbedManager;
import com.samvolvo.discordlinked.minecraft.commands.Link;
import com.samvolvo.discordlinked.minecraft.commands.Warn;
import com.samvolvo.discordlinked.minecraft.events.CommandEvent;
import com.samvolvo.discordlinked.minecraft.events.McChatEvent;
import com.samvolvo.discordlinked.minecraft.events.OnJoin;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.sharding.DefaultShardManagerBuilder;
import net.dv8tion.jda.api.sharding.ShardManager;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class DiscordLinked
extends JavaPlugin {
    private static DiscordLinked instance;
    private static FileConfiguration config;
    private static File configFile;
    private static ShardManager shardManager;
    private static File userDirectory;
    private int tokenState;
    private static Database database;
    private PlayerDataUtil playerDataUtil;
    private PlayerCache playerCache;
    private CodeCache codeCache;
    private Messages messages;
    private DiscordTools discordTools;
    private MinecraftTools minecraftTools;
    private EmbedManager embedManager;
    private UpdateChecker updateChecker;
    private String prefix;

    public void onEnable() {
        instance = this;
        Bukkit.getConsoleSender().sendMessage("\u00a7bDiscord\u00a7aLinked\u00a77: \u00a7aActive");
        this.saveDefaultConfig();
        this.loadConfig();
        this.prefix = this.getConfig().getString("minecraft.prefix");
        String token = this.getConfig().getString("DC_Token");
        if (token == null || token.isEmpty()) {
            this.getLogger().warning("Disabling DiscordLinked: Please fill in the bot token in the config.yml! Code: 0");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            this.tokenState = 0;
            return;
        }
        String url = this.getConfig().getString("database.URL");
        String name = this.getConfig().getString("database.Name");
        String user = this.getConfig().getString("database.User");
        String password = this.getConfig().getString("database.Password");
        if (url == null || url.isEmpty() || name == null || name.isEmpty() || user == null || user.isEmpty() || password == null || password.isEmpty()) {
            this.getLogger().warning("Disabling DiscordLinked: Please fill in the database credentials in the config.yml! Code: 0");
            this.tokenState = 0;
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        database = new Database(this);
        this.playerCache = new PlayerCache(this);
        this.codeCache = new CodeCache();
        this.playerDataUtil = new PlayerDataUtil(this);
        this.embedManager = new EmbedManager(this);
        DefaultShardManagerBuilder builder = DefaultShardManagerBuilder.createDefault(this.getConfig().getString("DC_Token"));
        builder.setStatus(OnlineStatus.DO_NOT_DISTURB);
        builder.setActivity(Activity.playing("Minecraft"));
        builder.enableIntents(GatewayIntent.GUILD_MEMBERS, GatewayIntent.GUILD_MESSAGES, GatewayIntent.MESSAGE_CONTENT);
        builder.build();
        shardManager = builder.build();
        this.discordTools = new DiscordTools(this);
        this.minecraftTools = new MinecraftTools(this);
        this.messages = new Messages(this);
        shardManager.addEventListener(new CommandManager(this), new DcChatEvent(this), new Account(this), new com.samvolvo.discordlinked.discord.commands.Link(this));
        this.getCommand("link").setExecutor((CommandExecutor)new Link(this));
        this.getCommand("warn").setExecutor((CommandExecutor)new Warn(this));
        Bukkit.getPluginManager().registerEvents((Listener)new McChatEvent(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new CommandEvent(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnJoin(this), (Plugin)this);
        Metrics metrics = new Metrics((Plugin)this, 23402);
        this.updateChecker = new UpdateChecker(this);
        List<String> nameless = this.updateChecker.generateUpdateMessage(this.getDescription().getVersion());
        if (!nameless.isEmpty()) {
            for (String message : nameless) {
                Bukkit.getLogger().warning(message);
            }
        }
        this.tokenState = 1;
    }

    public void onDisable() {
        if (this.tokenState != 0) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.messages.sendJoinLeaveDc(player, "leave");
            }
            this.messages.sendEmbedDc(EmbedManager.startStop("off"));
        }
        Bukkit.getConsoleSender().sendMessage("\u00a7bDiscord&aLinked: \u00a7c\u00a7lDisabled");
        this.saveConfig();
    }

    public ShardManager getShardManager() {
        return shardManager;
    }

    public PlayerCache getPlayerCache() {
        return this.playerCache;
    }

    public CodeCache getCodeCache() {
        return this.codeCache;
    }

    public PlayerDataUtil getPlayerDataUtil() {
        return this.playerDataUtil;
    }

    public DiscordTools getDiscordTools() {
        return this.discordTools;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public MinecraftTools getMinecraftTools() {
        return this.minecraftTools;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public EmbedManager getEmbedManager() {
        return this.embedManager;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    private void loadConfig() {
        if (configFile == null) {
            configFile = new File(this.getDataFolder(), "config.yml");
        }
        config = YamlConfiguration.loadConfiguration((File)configFile);
    }

    public void saveConfig() {
        try {
            config.save(configFile);
        }
        catch (IOException e) {
            this.getLogger().warning("Unable to save config.yml!");
        }
    }

    public static Database getDatabase() {
        return database;
    }

    public static DiscordLinked getInstance() {
        return instance;
    }
}

