/*
 * Decompiled with CFR 0.152.
 */
package com.samvolvo.discordlinked.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.samvolvo.discordlinked.DiscordLinked;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class UpdateChecker {
    private final DiscordLinked plugin;
    private final String RELEASES_URL = "https://api.github.com/repos/SamVolvo/DiscordLinked/releases";

    public UpdateChecker(DiscordLinked plugin) {
        this.plugin = plugin;
    }

    public List<String> generateUpdateMessage(String v) {
        try {
            String currentVersion = "V" + v;
            int releasesBehind = this.getReleasesBehind(currentVersion);
            JsonArray releases = this.getAllReleases();
            String tagName = releases.get(0).getAsJsonObject().get("tag_name").getAsString();
            ArrayList<String> message = new ArrayList<String>();
            if (releasesBehind <= 0) {
                return message;
            }
            message.add("*********************************************************************");
            message.add("DiscordLinked is outdated!");
            message.add("\"Latest version: " + tagName);
            message.add("Your version: " + this.plugin.getDescription().getVersion());
            message.add("https://www.spigotmc.org/resources/discordlinked.119665/");
            message.add("*********************************************************************");
            return message;
        }
        catch (Exception e) {
            return Collections.singletonList("Unable to connect to version Check!");
        }
    }

    public String generateUpdateMessageColored(String v) {
        String currentVersion = "V" + v;
        int releasesBehind = this.getReleasesBehind(currentVersion);
        if (releasesBehind > 0) {
            return "\u00a7cYou are \u00a74" + releasesBehind + "\u00a7c release(s) behind!\nDownload the newest release at https://www.spigotmc.org/resources/discordlinked.119665/";
        }
        return null;
    }

    private int getReleasesBehind(String currentVersion) {
        try {
            int behind = 0;
            JsonArray releases = this.getAllReleases();
            if (releases != null) {
                for (JsonElement release : releases) {
                    String tagName = release.getAsJsonObject().get("tag_name").getAsString();
                    if (!tagName.equalsIgnoreCase(currentVersion)) {
                        ++behind;
                        continue;
                    }
                    return behind;
                }
                return behind;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    private JsonArray getAllReleases() throws IOException {
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url("https://api.github.com/repos/SamVolvo/DiscordLinked/releases").build();
        try (Response response = client.newCall(request).execute();){
            if (response.isSuccessful() && response.body() != null) {
                JsonArray jsonArray = JsonParser.parseString(response.body().string()).getAsJsonArray();
                return jsonArray;
            }
            JsonArray jsonArray = null;
            return jsonArray;
        }
    }
}

