/*
 * Decompiled with CFR 0.152.
 */
package com.samvolvo.discordlinked.api.database;

import com.samvolvo.discordlinked.DiscordLinked;
import com.samvolvo.discordlinked.api.database.models.PlayerData;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;

public class Database {
    private HikariDataSource dataSource;
    private DiscordLinked plugin;

    public Database(DiscordLinked discordLinked) {
        try {
            this.plugin = discordLinked;
            FileConfiguration config = this.plugin.getConfig();
            HikariConfig dbConfig = new HikariConfig();
            dbConfig.setJdbcUrl("jdbc:mysql://" + config.getString("database.URL") + "/" + config.getString("database.Name"));
            dbConfig.setUsername(config.getString("database.User"));
            dbConfig.setPassword(config.getString("database.Password"));
            dbConfig.addDataSourceProperty("cachePrepStmts", "true");
            dbConfig.addDataSourceProperty("prepStmtCacheSize", "250");
            dbConfig.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
            dbConfig.setMaximumPoolSize(100);
            this.dataSource = new HikariDataSource(dbConfig);
            try (Connection connection = this.dataSource.getConnection();){
                if (connection != null && !connection.isClosed()) {
                    this.plugin.getLogger().info("Successfully connected to the database.");
                }
                this.createTables();
            }
            catch (SQLException e) {
                this.plugin.getLogger().info("Failed to connect to the database. Code: 13");
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("Could not connect to a database.");
        }
    }

    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            this.plugin.getLogger().info("An error accured while trying to get the database. Code: 13");
            return null;
        }
    }

    public void close() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
        }
    }

    private void createTables() {
        Connection connection = this.getConnection();
        try {
            Statement playerDataStatement = connection.createStatement();
            playerDataStatement.execute("CREATE TABLE IF NOT EXISTS PlayerData(DataId INT AUTO_INCREMENT PRIMARY KEY, uuid varchar(36), id varchar(36), warnings TINYINT UNSIGNED);");
        }
        catch (SQLException e) {
            this.plugin.getLogger().info("There was an error in the database. Code: 14");
        }
    }

    public PlayerData findPlayerDataByUUID(String uuid) {
        PreparedStatement statement = null;
        try {
            statement = this.getConnection().prepareStatement("SELECT * FROM PlayerData WHERE uuid = ?;");
            statement.setString(1, uuid);
            ResultSet results = statement.executeQuery();
            if (results.next()) {
                int DataId = results.getInt("DataId");
                String Id2 = results.getString("id");
                int warnings = results.getInt("warnings");
                PlayerData data = new PlayerData(DataId, uuid, Id2, warnings);
                statement.close();
                return data;
            }
            statement.close();
            PlayerData data = new PlayerData(0, uuid, null, 0);
            this.createPlayerData(data);
            return data;
        }
        catch (SQLException e) {
            this.plugin.getLogger().info("There was an error finding data in the database. Code: 15");
            throw new RuntimeException(e);
        }
    }

    public PlayerData findPlayerDataById(String id) {
        PreparedStatement statement = null;
        try {
            statement = this.getConnection().prepareStatement("SELECT * FROM PlayerData WHERE id = ?;");
            statement.setString(1, id);
            ResultSet results = statement.executeQuery();
            if (results.next()) {
                int DataId = results.getInt("DataId");
                String uuid = results.getString("uuid");
                int warnings = results.getInt("warnings");
                PlayerData data = new PlayerData(DataId, uuid, id, warnings);
                statement.close();
                return data;
            }
            statement.close();
            PlayerData data = new PlayerData(0, null, id, 0);
            this.createPlayerData(data);
            return data;
        }
        catch (SQLException e) {
            this.plugin.getLogger().info("There was an error finding data in the database. Code: 15");
            throw new RuntimeException(e);
        }
    }

    private void createPlayerData(PlayerData data) {
        try {
            PreparedStatement statement = this.getConnection().prepareStatement("INSERT INTO PlayerData (uuid, id, warnings) VALUES (?, ?, ?);");
            statement.setString(1, data.getUuid());
            statement.setString(2, data.getId());
            statement.setInt(3, data.getWarnings());
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException e) {
            this.plugin.getLogger().info("There was an error creating player data in the database. Code: 16");
            throw new RuntimeException(e);
        }
    }

    public void updatePlayerData(PlayerData playerData) {
        try {
            PreparedStatement statement = this.getConnection().prepareStatement("UPDATE PlayerData SET id = ?, warnings = ? WHERE uuid = ?;");
            statement.setString(1, playerData.getId());
            statement.setInt(2, playerData.getWarnings());
            statement.setString(3, playerData.getUuid());
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException e) {
            this.plugin.getLogger().info("There was an error updating player data in the database. Code: 17");
            throw new RuntimeException(e);
        }
    }
}

