/*
 * Decompiled with CFR 0.152.
 */
package com.samvolvo.discordlinked.minecraft.events;

import com.samvolvo.discordlinked.DiscordLinked;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

public class CommandEvent
implements Listener {
    private final DiscordLinked plugin;
    private final List<String> blockedCommands = new ArrayList<String>();

    public CommandEvent(DiscordLinked plugin) {
        this.plugin = plugin;
        List ignoredCommands = plugin.getConfig().getList("minecraft.sendCommands.ignoredCommands");
        if (ignoredCommands != null) {
            this.blockedCommands.addAll(ignoredCommands);
        }
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (!this.plugin.getConfig().getBoolean("minecraft.sendCommands.isEnabled")) {
            return;
        }
        Player player = event.getPlayer();
        String command = event.getMessage().substring(1);
        if (this.blockedCommands.contains(command)) {
            return;
        }
        if (player.hasPermission("discordlinked.alerts.bypass")) {
            return;
        }
        this.plugin.getMessages().commandSendMC("/" + command, player);
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!p.hasPermission("discordlinked.alerts")) continue;
            p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.plugin.getPrefix() + " &c" + player.getDisplayName() + " &e has used &b/" + command + " &e in minecraft.")));
        }
    }
}

