/*
 * Decompiled with CFR 0.152.
 */
package com.samvolvo.discordlinked.minecraft.events;

import com.samvolvo.discordlinked.DiscordLinked;
import com.samvolvo.discordlinked.api.database.PlayerCache;
import com.samvolvo.discordlinked.api.database.models.PlayerData;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class OnJoin
implements Listener {
    private final DiscordLinked plugin;
    private final PlayerCache playerCache;
    private final Map<Player, Long> titleTimer = new HashMap<Player, Long>();

    public OnJoin(DiscordLinked plugin) {
        this.plugin = plugin;
        this.playerCache = plugin.getPlayerCache();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        String versionMessage = this.plugin.getUpdateChecker().generateUpdateMessageColored(this.plugin.getDescription().getVersion());
        if (versionMessage != null) {
            e.getPlayer().sendMessage(versionMessage);
        }
        if (this.plugin.getConfig().getBoolean("general.joinMessages")) {
            this.plugin.getMessages().sendJoinLeaveDc(e.getPlayer(), "join");
        }
        if (!this.plugin.getConfig().getBoolean("minecraft.needVerifiedDiscord")) {
            return;
        }
        PlayerData data = this.plugin.getPlayerDataUtil().getDataByUuid(e.getPlayer().getUniqueId().toString());
        this.plugin.getPlayerCache().put(data.getUuid(), data);
        if (data.getId() != null && data.getId() != "") {
            return;
        }
        e.getPlayer().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.plugin.getConfig().getString("minecraft.prefix") + "&7: &cYou need to link your discord account to play on this server!")));
        TextComponent message = new TextComponent("\u00a7eClick here to join the discord!");
        message.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, this.plugin.getConfig().getString("discord.invite")));
        e.getPlayer().spigot().sendMessage((BaseComponent)message);
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent e) {
        this.plugin.getPlayerCache().remove(e.getPlayer().getUniqueId().toString());
        this.plugin.getMessages().sendJoinLeaveDc(e.getPlayer(), "leave");
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        if (!this.plugin.getConfig().getBoolean("minecraft.needVerifiedDiscord")) {
            return;
        }
        PlayerData data = this.playerCache.get(e.getPlayer().getUniqueId().toString());
        if (data.getId() == null || data.getId().isEmpty()) {
            e.setCancelled(true);
            Player player = e.getPlayer();
            if (this.titleTimer.getOrDefault(player, 0L) < System.currentTimeMillis()) {
                this.plugin.getMinecraftTools().sendTitle(e.getPlayer(), "\u00a7cA linked account is required!", "\u00a7ePlease connect your discord account!");
                this.titleTimer.put(player, System.currentTimeMillis() + 3000L);
            }
        }
    }
}

