/*
 * Decompiled with CFR 0.152.
 */
package com.samvolvo.discordlinked.api.database.utils;

import com.samvolvo.discordlinked.DiscordLinked;
import com.samvolvo.discordlinked.api.database.Database;
import com.samvolvo.discordlinked.api.database.models.PlayerData;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class PlayerDataUtil {
    private final DiscordLinked plugin;
    private final Database database;

    public PlayerDataUtil(DiscordLinked plugin) {
        this.plugin = plugin;
        this.database = plugin.getDatabase();
    }

    public PlayerData getDataByUuid(String uuid) {
        PlayerData data = this.database.findPlayerDataByUUID(uuid);
        return data;
    }

    public void linkDiscord(UUID uuid, String id) {
        String Uuid = uuid.toString();
        PlayerData data = new PlayerData(0, Uuid, id, 0);
        this.database.updatePlayerData(data);
        this.plugin.getPlayerCache().put(Uuid, data);
    }

    public void updateData(String uuid, PlayerData data) {
        this.database.updatePlayerData(data);
        this.plugin.getPlayerCache().put(uuid, data);
    }

    public OfflinePlayer getPlayerById(String discordId) {
        UUID playerUUID;
        OfflinePlayer offlinePlayer;
        PlayerData data = this.database.findPlayerDataById(discordId);
        if (data.getUuid() == null) {
            return null;
        }
        if (data.getUuid() != null && (offlinePlayer = Bukkit.getOfflinePlayer((UUID)(playerUUID = UUID.fromString(data.getUuid())))) != null && offlinePlayer.hasPlayedBefore()) {
            return offlinePlayer;
        }
        return null;
    }
}

