/*
 * Decompiled with CFR 0.152.
 */
package com.samvolvo.discordlinked.api.tools;

import com.samvolvo.discordlinked.DiscordLinked;
import com.samvolvo.discordlinked.api.DiscordWebhooks;
import com.samvolvo.discordlinked.discord.managers.EmbedManager;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.sharding.ShardManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class Messages
extends ListenerAdapter {
    private final DiscordLinked plugin;
    private final String prefix;
    private final ShardManager shardManager;
    private final String guildId;
    private final String channelId;
    private final String adminChannel;

    public Messages(DiscordLinked plugin) {
        this.plugin = plugin;
        this.prefix = plugin.getConfig().getString("minecraft.prefix");
        this.shardManager = plugin.getShardManager();
        this.guildId = plugin.getConfig().getString("discord.guildId");
        this.channelId = DiscordLinked.getInstance().getConfig().getString("discord.chatChannel");
        this.adminChannel = DiscordLinked.getInstance().getConfig().getString("discord.adminChannel");
    }

    public void McMessage(Player player, String message) {
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&7: &e" + message)));
    }

    public void McError(Player player, int code) {
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&7: &cThere was an error! \u00a7aCode: " + code)));
    }

    public void sendMessageMc(Member member, String message) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.plugin.getConfig().getString("minecraft.messages.discord_prefix") + " &r" + member.getEffectiveName() + ": " + message)));
        }
    }

    public void sendJoinLeaveDc(Player p, String joinLeave) {
        Guild guild;
        try {
            guild = this.shardManager.getGuildById(this.plugin.getConfig().getString("discord.guildId"));
        }
        catch (NullPointerException e) {
            this.plugin.getLogger().info("Please specify a Guild ID in the config.");
            return;
        }
        if (guild == null) {
            this.plugin.getLogger().info("Guild not found! Guild ID might be incorrect.");
            return;
        }
        TextChannel channel = this.plugin.getDiscordTools().getTextChannel(this.channelId, guild);
        if (channel == null) {
            this.plugin.getLogger().info("Channel not found! Channel ID might be incorrect.");
            return;
        }
        if (joinLeave.equalsIgnoreCase("join")) {
            MessageEmbed joinEmbed = EmbedManager.joinEmbed(p);
            channel.sendMessageEmbeds(joinEmbed, new MessageEmbed[0]).queue();
        } else if (joinLeave.equalsIgnoreCase("leave")) {
            MessageEmbed leaveEmbed = EmbedManager.leaveEmbed(p);
            channel.sendMessageEmbeds(leaveEmbed, new MessageEmbed[0]).queue();
        }
    }

    public void joinAllPlayers() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.sendJoinLeaveDc(player, "join");
        }
    }

    public void commandSendMC(String command, Player p) {
        Guild guild = this.shardManager.getGuildById(this.guildId);
        TextChannel channel = this.plugin.getDiscordTools().getTextChannel(this.adminChannel, guild);
        String playerUUID = p.getUniqueId().toString();
        String avatarUrl = "https://api.mineatar.io/face/" + playerUUID;
        DiscordWebhooks.sendDiscordWebhookCommand(p.getName(), avatarUrl, command);
    }

    public void sendEmbedDc(MessageEmbed embed) {
        Guild guild = this.shardManager.getGuildById(this.guildId);
        TextChannel channel = this.plugin.getDiscordTools().getTextChannel(this.channelId, guild);
        channel.sendMessageEmbeds(embed, new MessageEmbed[0]).queue();
    }

    public void sendMessageDc(Player p, String message) {
        String playerName = p.getName();
        String playerUUID = p.getUniqueId().toString();
        String avatarUrl = "https://api.mineatar.io/face/" + playerUUID;
        DiscordWebhooks.sendDiscordWebhookChat(playerName, avatarUrl, message);
    }

    public void sendAdminEmbed(MessageEmbed embed) {
        Guild guild = this.shardManager.getGuildById(this.guildId);
        TextChannel channel = this.plugin.getDiscordTools().getTextChannel(this.adminChannel, guild);
        channel.sendMessageEmbeds(embed, new MessageEmbed[0]).queue();
    }
}

