/*
 * Decompiled with CFR 0.152.
 */
package com.samvolvo.discordlinked.minecraft.commands;

import com.samvolvo.discordlinked.DiscordLinked;
import com.samvolvo.discordlinked.api.database.models.PlayerData;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Warn
implements CommandExecutor {
    private final DiscordLinked plugin;

    public Warn(DiscordLinked plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args2) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!player.hasPermission("discordlinked.warn")) {
                this.plugin.getMessages().McError(player, 2);
                return true;
            }
            if (args2.length != 1) {
                this.plugin.getMessages().McError(player, 12);
                return false;
            }
            Player target = Bukkit.getPlayer((String)args2[0]);
            if (target == null) {
                this.plugin.getMessages().McError(player, 3);
                return true;
            }
            PlayerData data = this.plugin.getPlayerCache().get(target.getUniqueId().toString());
            int warnings = data.getWarnings();
            data.setWarnings(warnings + 1);
            this.plugin.getPlayerCache().put(data.getUuid(), data);
            this.plugin.getPlayerDataUtil().updateData(data.getUuid(), data);
            this.plugin.getMessages().McMessage(player, this.plugin.getPrefix() + "&7: &eWarned " + target.getName());
            this.plugin.getMessages().McMessage(target, this.plugin.getPrefix() + "&7: &eYou just got warned by &c" + player.getDisplayName());
        }
        return true;
    }
}

