const audio = document.getElementById('audio');
const playPauseButton = document.getElementById('play-pause');
const prevButton = document.getElementById('prev');
const nextButton = document.getElementById('next');
const progressBar = document.getElementById('progress-bar');
const progressBarInner = document.getElementById('progress-bar-inner');
const timeElapsed = document.getElementById('time-elapsed');
const timeTotal = document.getElementById('time-total');

let isPlaying = false;
let currentTime = 0;
let duration = 0;

audio.addEventListener('loadedmetadata', () => {
  duration = audio.duration;
  timeTotal.textContent = formatTime(duration);
});

audio.addEventListener('timeupdate', () => {
  currentTime = audio.currentTime;
  timeElapsed.textContent = formatTime(currentTime);
  progressBarInner.style.width = `${(currentTime / duration) * 100}%`;
});

playPauseButton.addEventListener('click', () => {
  if (isPlaying) {
    audio.pause();
    playPauseButton.innerHTML = '<i class="fas fa-play color-white"></i>';
  } else {
    audio.play();
    playPauseButton.innerHTML = '<i class="fas fa-pause color-white"></i>';
  }
  isPlaying = !isPlaying;
});

prevButton.addEventListener('click', () => {
  audio.currentTime -= 10;
});

nextButton.addEventListener('click', () => {
  audio.currentTime += 10;
});

function formatTime(time) {
  const minutes = Math.floor(time / 60);
  const seconds = Math.floor(time % 60);
  return `${minutes}:${seconds.toString().padStart(2, '0')}`;
}